<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UnitSchedule extends Eloquent {

	protected $table = 'unit_schedules';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('unit_id', 'name', 'set_on', 'set_to');
	protected $visible = array('unit_id', 'name', 'set_on', 'set_to');

	public function unit()
	{
		return $this->belongsTo('App\Unit');
	}

}