<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 255)->unique();
			$table->string('email', 100)->unique();
			$table->string('password', 60);
			$table->string('remember_token', 100);
			$table->timestamps();
			$table->integer('role_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}