<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSongsTable extends Migration {

	public function up()
	{
		Schema::create('songs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 255);
			$table->integer('song_type_id')->unsigned();
			$table->integer('album_id')->unsigned();
			$table->integer('parent_id')->unsigned()->nullable();
			$table->integer('language_id')->unsigned();
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('songs');
	}
}