<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonsTable extends Migration {

	public function up()
	{
		Schema::create('lessons', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('excerpt');
			$table->enum('type', array('written', 'video'));
			$table->bigInteger('course_id')->primary()->unsigned()->index();
			$table->bigInteger('section_id')->primary()->unsigned()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('lessons');
	}
}