<?php

class Course extends Eloquent {

	protected $table = 'courses';
	public $timestamps = true;

	public function sections()
	{
		return $this->hasMany('Section', 'course_id');
	}

	public function lessons()
	{
		return $this->hasMany('Lesson', 'course_id');
	}

	public function exams()
	{
		return $this->hasMany('Exam', 'course_id');
	}

	public function questions()
	{
		return $this->hasMany('ExamQuestion', 'course_id');
	}

	public function teacher()
	{
		return $this->belongsTo('Teacher', 'teacher_id');
	}

	public function videos()
	{
		return $this->hasMany('Video', 'course_id');
	}

	public function files()
	{
		return $this->hasMany('CourseFile');
	}

	public function testimonials()
	{
		return $this->hasMany('CourseTestimonial');
	}

}