<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Teacher extends Eloquent {

	protected $table = 'teachers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function courses()
	{
		return $this->hasMany('Course', 'teacher_id');
	}

	public function testimonials()
	{
		return $this->hasMany('TeacherTestimonial');
	}

}