<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlayerPointsTable extends Migration {

	public function up()
	{
		Schema::create('player_points', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('player_id')->unsigned();
			$table->binary('rule_hash')->nullable();
			$table->tinyInteger('week');
			$table->integer('season');
			$table->decimal('points');
		});
	}

	public function down()
	{
		Schema::drop('player_points');
	}
}