<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyAddressTable extends Migration {

	public function up()
	{
		Schema::create('company_address', function(Blueprint $table) {
			$table->increments('id');
			$table->string('city');
			$table->integer('companies_id')->unsigned();
			$table->integer('country_code_id')->unsigned();
			$table->string('state');
			$table->string('street');
			$table->string('zipcode');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('company_address');
	}
}