<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigIncrements('uuid');
			$table->string('slug', 255)->unique();
			$table->integer('category_id')->unsigned();
			$table->string('feature_image', 255);
			$table->text('media');
			$table->integer('view_counts');
			$table->integer('avg_rating');
			$table->timestamps();
			$table->integer('created_by')->unsigned();
			$table->integer('updated_by')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}