<?php

namespace App;

class DonationRequest extends Eloquent {

	protected $table = 'donation_requests';
	public $timestamps = true;
	protected $fillable = array('patient_name', 'patient_age', 'hospital_name', 'hospital_address', 'latitude', 'longitude', 'bags_number', 'phone', 'blood_type_id', 'client_id', 'city_id');

	public function bloodType()
	{
		return $this->belongsTo('App\BloodType');
	}

	public function clients()
	{
		return $this->belongsTo('App\Client');
	}

	public function governorate()
	{
		return $this->belongsTo('App\Governorate');
	}

	public function notification()
	{
		return $this->hasOne('App\Notification');
	}

}