<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('produits', function(Blueprint $table) {
			$table->foreign('categorie_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('entrees_produit', function(Blueprint $table) {
			$table->foreign('detailEntreeProduit_id')->references('id')->on('details_entree_produit')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('details_entree_produit', function(Blueprint $table) {
			$table->foreign('entreeProduit_id')->references('id')->on('entrees_produit')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('details_entree_produit', function(Blueprint $table) {
			$table->foreign('fournisseur_id')->references('id')->on('fournisseurs')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('details_entree_produit', function(Blueprint $table) {
			$table->foreign('produit_id')->references('id')->on('produits')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ventes_produit', function(Blueprint $table) {
			$table->foreign('detailVenteProduit_id')->references('id')->on('details_vente_produit')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('details_vente_produit', function(Blueprint $table) {
			$table->foreign('venteProduit_id')->references('id')->on('ventes_produit')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('details_vente_produit', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('details_vente_produit', function(Blueprint $table) {
			$table->foreign('produit_id')->references('id')->on('produits')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('produits', function(Blueprint $table) {
			$table->dropForeign('produits_categorie_id_foreign');
		});
		Schema::table('entrees_produit', function(Blueprint $table) {
			$table->dropForeign('entrees_produit_detailEntreeProduit_id_foreign');
		});
		Schema::table('details_entree_produit', function(Blueprint $table) {
			$table->dropForeign('details_entree_produit_entreeProduit_id_foreign');
		});
		Schema::table('details_entree_produit', function(Blueprint $table) {
			$table->dropForeign('details_entree_produit_fournisseur_id_foreign');
		});
		Schema::table('details_entree_produit', function(Blueprint $table) {
			$table->dropForeign('details_entree_produit_produit_id_foreign');
		});
		Schema::table('ventes_produit', function(Blueprint $table) {
			$table->dropForeign('ventes_produit_detailVenteProduit_id_foreign');
		});
		Schema::table('details_vente_produit', function(Blueprint $table) {
			$table->dropForeign('details_vente_produit_venteProduit_id_foreign');
		});
		Schema::table('details_vente_produit', function(Blueprint $table) {
			$table->dropForeign('details_vente_produit_client_id_foreign');
		});
		Schema::table('details_vente_produit', function(Blueprint $table) {
			$table->dropForeign('details_vente_produit_produit_id_foreign');
		});
	}
}