<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Produit extends Eloquent {

	protected $table = 'produits';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function categorie()
	{
		return $this->hasOne('Categorie');
	}

	public function detailEntreeProduit()
	{
		return $this->hasMany('DetailEntreeProduit');
	}

	public function detailsVenteProduit()
	{
		return $this->hasMany('DetailVenteProduit');
	}

}