<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCaptainInfosTable extends Migration {

	public function up()
	{
		Schema::create('captain_infos', function(Blueprint $table) {
			$table->increments('id');
			$table->string('identification_number');
			$table->timestamps();
			$table->string('license_number');
			$table->string('driving_license_number');
			$table->integer('car_model_id')->unsigned();
			$table->integer('car_class_id')->unsigned();
			$table->string('name_bank');
			$table->string('account_number');
			$table->string('gender');
			$table->string('nationality');
			$table->integer('captain_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('captain_infos');
	}
}