<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChatMessagesTable extends Migration {

	public function up()
	{
		Schema::create('chat_messages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('sender');
			$table->text('message_text');
			$table->string('readed_at');
			$table->integer('chat_id')->unsigned();
			$table->string('created_by_id');
			$table->string('created_by_type');
			$table->string('order_id');
		});
	}

	public function down()
	{
		Schema::drop('chat_messages');
	}
}