<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->bigInteger('store_id')->unsigned()->nullable();
			$table->integer('subtotal_price');
			$table->integer('total_price');
			$table->string('type', 225);
			$table->string('status');
			$table->string('payment_method');
			$table->char('source_coordinates');
			$table->string('distination_coordinates');
			$table->json('user_address');
			$table->string('note')->nullable();
			$table->string('points');
			$table->string('coupon');
			$table->string('zakat');
			$table->string('tax');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}