<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('email_queue', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('email_sending_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('email_queue', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('email_queue', function(Blueprint $table) {
			$table->dropForeign('email_queue_status_id_foreign');
		});
		Schema::table('email_queue', function(Blueprint $table) {
			$table->dropForeign('email_queue_sender_id_foreign');
		});
	}
}