<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmailQueueTable extends Migration {

	public function up()
	{
		Schema::create('email_queue', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('status_id')->unsigned();
			$table->integer('sender_id')->unsigned();
			$table->string('sender_name');
			$table->string('sender_email');
			$table->string('subject');
			$table->string('send_to');
			$table->string('cc');
			$table->string('bcc');
			$table->text('body');
			$table->text('attachments');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('email_queue');
	}
}