<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAuditorTable extends Migration {

	public function up()
	{
		Schema::create('auditor', function(Blueprint $table) {
			$table->increments('id', true);
			$table->integer('table_id')->unsigned();
			$table->string('table_name', 150);
			$table->tinyInteger('action_type')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->timestamps();
			$table->json('data')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('auditor');
	}
}