<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModulesTable extends Migration {

	public function up()
	{
		Schema::create('modules', function(Blueprint $table) {
			$table->increments('id', true);
			$table->string('name', 200);
			$table->string('url', 150)->nullable();
			$table->text('description');
			$table->integer('parent_id')->unsigned()->nullable();
			$table->integer('organization_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('modules');
	}
}