<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModulesTable extends Migration {

	public function up()
	{
		Schema::create('modules', function(Blueprint $table) {
			$table->string('module_id')->unique()->primary();
			$table->string('module_name');
			$table->integer('module_volume_horaire');
			$table->integer('seuil_reussite');
			$table->integer('seuil_absence');
			$table->boolean('is_archived')->default(false );
			$table->longText('description')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('modules');
	}
}