<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingLabelsTable extends Migration {

	public function up()
	{
		Schema::create('shipping_labels', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->text('barcode')->nullable();
			$table->integer('shipping_product_id')->unsigned();
			$table->integer('weight')->nullable();
			$table->integer('weight_carrier')->nullable();
			$table->text('addres_from')->nullable();
			$table->text('address_to')->nullable();
			$table->text('status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('shipping_labels');
	}
}