<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingProductsTable extends Migration {

	public function up()
	{
		Schema::create('shipping_products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('shipping_company')->unsigned();
			$table->string('name', 50)->nullable();
			$table->string('name-slug', 50)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('shipping_products');
	}
}