<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ShippingInsurance extends Eloquent {

	protected $table = 'shipping_insurances';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function rates()
	{
		return $this->belongsToMany('ShippingRate');
	}

	public function ranges()
	{
		return $this->hasMany('ShippingInsuranceRange');
	}

}