<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ShippingInsuranceRange extends Eloquent {

	protected $table = 'shipping_insurance_ranges';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('value_from', 'value_until', 'price');

	public function insurance()
	{
		return $this->belongsTo('ShippingInsurance');
	}

}