<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ShippingProduct extends Eloquent {

	protected $table = 'shipping_products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function shipping_company()
	{
		return $this->belongsTo('ShippingComany');
	}

	public function rates()
	{
		return $this->hasMany('ShippingRate');
	}

}