<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ShippingRate extends Eloquent {

	protected $table = 'shipping_rates';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('price_default', 'customs', 'fuel_tax', 'fuel_tax_type', 'carrier_rules');

	public function product()
	{
		return $this->belongsTo('ShippingProduct');
	}

	public function ranges()
	{
		return $this->hasMany('ShippingRateRange');
	}

	public function insurance()
	{
		return $this->hasOne('ShippingInsurance');
	}

	public function places()
	{
		return $this->hasMany('ShippingPlace')->withDropOff()->withPickup();
	}

	public function company()
	{
		return $this->belongsTo('ShippingComany');
	}

}