<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function children()
    {
        return $this->hasMany('Children');
    }

    public function topics()
    {
        return $this->belongsToMany('Topic');
    }

    public function posts()
    {
        return $this->hasMany('Post');
    }

    public function type()
    {
        return $this->belongsTo('PersonType');
    }

}