<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminUsersTable extends Migration {

	public function up()
	{
		Schema::create('admin_users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 256)->nullable();
			$table->string('email', 256)->nullable();
			$table->string('password', 256)->nullable();
			$table->integer('mobile')->nullable();
			$table->tinyInteger('role')->nullable();
			$table->tinyInteger('status')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('admin_users');
	}
}