<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogTable extends Migration {

	public function up()
	{
		Schema::create('blog', function(Blueprint $table) {
			$table->increments('id');
			$table->text('title')->nullable();
			$table->text('sub_title')->nullable();
			$table->text('content')->nullable();
			$table->text('image')->nullable();
			$table->tinyInteger('status')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('blog');
	}
}