<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('session_token', 256)->nullable();
			$table->string('name', 256)->nullable();
			$table->string('email', 256)->nullable();
			$table->integer('mobile')->nullable();
			$table->string('country', 256)->nullable();
			$table->text('address')->nullable();
			$table->string('city', 256)->nullable();
			$table->smallInteger('pincode')->nullable();
			$table->tinyInteger('status')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}