<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('Contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('Created_by', 30);
			$table->string('Updated_by', 30);
			$table->integer('Supplier_id')->unsigned();
			$table->enum('types', array('AP', 'AR'));
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('socials', 255);
			$table->string('phone', 255);
			$table->string('fax', 255);
		});
	}

	public function down()
	{
		Schema::drop('Contacts');
	}
}