<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('Products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('Product_id')->unique();
			$table->string('Name');
			$table->string('Barcode')->unique();
			$table->text('Description');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('Unit_id')->unsigned();
			$table->decimal('UnitCost');
			$table->decimal('Price');
			$table->integer('Category_id');
			$table->string('Created_by', 30);
			$table->string('Updated_by', 30);
			$table->integer('parent_id');
			$table->enum('Status', array('???', '???????', '????'));
			$table->text('photo1');
			$table->text('photo2');
			$table->text('photo3');
			$table->text('photo4');
			$table->decimal('onHand');
			$table->string('Incoming');
			$table->decimal('Stock');
			$table->string('ref1', 255);
			$table->string('ref2', 255);
			$table->string('ref3', 255);
			$table->string('ref4', 255);
			$table->text('Notes');
			$table->string('pomotion_ref', 255);
		});
	}

	public function down()
	{
		Schema::drop('Products');
	}
}