<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePromotionsTable extends Migration {

	public function up()
	{
		Schema::create('Promotions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('group', 250);
			$table->enum('Status', array('Active', 'Inactive'));
			$table->datetime('Start_date');
			$table->datetime('Expire_date');
			$table->integer('priority');
			$table->string('Name', 150);
			$table->text('Description');
			$table->text('condition');
			$table->text('functions');
			$table->string('parametors', 255);
			$table->timestamps();
			$table->softDeletes();
			$table->string('Updated_by', 30);
			$table->string('Created_by', 30);
		});
	}

	public function down()
	{
		Schema::drop('Promotions');
	}
}