<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Customer extends Eloquent {

	protected $table = 'Customers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Customer_Invoice()
	{
		return $this->hasMany('Invoice', 'Customer_id');
	}

	public function HaveContact()
	{
		return $this->hasMany('Contact');
	}

	public function HaveShipaddress()
	{
		return $this->hasMany('Shippingaddress');
	}

	public function Havepomotion()
	{
		return $this->hasMany('Promo_cus');
	}

	public function Havesaveprice()
	{
		return $this->hasMany('Saleprice');
	}

	public function Havedetail()
	{
		return $this->hasMany('SubCusDetail');
	}

}