<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgentsTable extends Migration {

	public function up()
	{
		Schema::create('agents', function(Blueprint $table) {
			$table->bigInteger('id')->primary()->index();
			$table->integer('discipline_id')->index();
			$table->integer('fonction_id')->index();
			$table->integer('ecole_id')->index();
			$table->integer('emploi_id')->index();
			$table->string('nom_jeune_fille', 255);
			$table->string('matricule', 255);
			$table->date('date_naissance');
			$table->string('telephone_mobile', 255);
			$table->string('telephone_bureau', 255);
		});
	}

	public function down()
	{
		Schema::drop('agents');
	}
}