<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('directorys', function(Blueprint $table) {
			$table->foreign('parentDirectory')->references('directoryID')->on('directorys')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('inDirectory', function(Blueprint $table) {
			$table->foreign('documentID')->references('documentID')->on('documents')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('inDirectory', function(Blueprint $table) {
			$table->foreign('directoryID')->references('directoryID')->on('directorys')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('documentID')->references('documentID')->on('documents')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('userID')->references('userID')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('postdetail', function(Blueprint $table) {
			$table->foreign('userID')->references('userID')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('postdetail', function(Blueprint $table) {
			$table->foreign('documentID')->references('documentID')->on('documents')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('directorys', function(Blueprint $table) {
			$table->dropForeign('directorys_parentDirectory_foreign');
		});
		Schema::table('inDirectory', function(Blueprint $table) {
			$table->dropForeign('inDirectory_documentID_foreign');
		});
		Schema::table('inDirectory', function(Blueprint $table) {
			$table->dropForeign('inDirectory_directoryID_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_documentID_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_userID_foreign');
		});
		Schema::table('postdetail', function(Blueprint $table) {
			$table->dropForeign('postdetail_userID_foreign');
		});
		Schema::table('postdetail', function(Blueprint $table) {
			$table->dropForeign('postdetail_documentID_foreign');
		});
	}
}