<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'Users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Images()
    {
        return $this->hasMany('Image');
    }

    public function Votes()
    {
        return $this->hasMany('Vote');
    }

    public function Friends()
    {
        return $this->hasMany('Friend');
    }

}