<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('StockBook-Vehicles', function(Blueprint $table) {
			$table->foreign('location')->references('id')->on('Facilities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Trips', function(Blueprint $table) {
			$table->foreign('from')->references('id')->on('Facilities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('StockBook-Vehicles', function(Blueprint $table) {
			$table->dropForeign('StockBook-Vehicles_location_foreign');
		});
		Schema::table('Trips', function(Blueprint $table) {
			$table->dropForeign('Trips_from_foreign');
		});
	}
}