<?php

namespace App\models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'watsapp_number', 'city_id', 'area_id', 'fb_account', 'type');

	public function speciality()
	{
		return $this->belongsToMany('App\models\Speciality');
	}

	public function area()
	{
		return $this->belongsTo('App\models\Area', 'area_id');
	}

}