<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'company';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function products()
	{
		return $this->belongsToMany('Product', 'company_region_product', 'company_id', 'product_id')->withPivot('region_id')->join('region', 'region_id', '=', 'region.id');
	}

	public function regions()
	{
		return $this->belongsToMany('Region', 'company_region_product', 'company_id', 'region_id')->withPivot('product_id')->join('product', 'product_id', '=', 'product.id');
	}

	public function vacancies()
	{
		return $this->hasMany('Vacancy');
	}

	public function news()
	{
		return $this->hasMany('News');
	}

	public function offers()
	{
		return $this->hasMany('Offer');
	}

}