<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('quests', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('quest_id')->references('id')->on('quests')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('quest_id')->references('id')->on('quests')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('quest_prices', function(Blueprint $table) {
			$table->foreign('quest_id')->references('id')->on('quests')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('quest_prices', function(Blueprint $table) {
			$table->foreign('day_type_id')->references('id')->on('day_types')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('day_type_id')->references('id')->on('day_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('quests', function(Blueprint $table) {
			$table->dropForeign('quests_city_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_quest_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_quest_id_foreign');
		});
		Schema::table('quest_prices', function(Blueprint $table) {
			$table->dropForeign('quest_prices_quest_id_foreign');
		});
		Schema::table('quest_prices', function(Blueprint $table) {
			$table->dropForeign('quest_prices_day_type_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_day_type_id_foreign');
		});
	}
}