<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Quest extends Eloquent {

	protected $table = 'quests';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('city_id', 'title', 'description', 'rules', 'duration', 'break_time');
	protected $visible = array('city_id', 'title', 'description', 'rules', 'duration', 'break_time');

	public function city()
	{
		return $this->belongsTo('City');
	}

	public function comments()
	{
		return $this->hasMany('Comment', 'quest_id');
	}

	public function orders()
	{
		return $this->hasMany('Order');
	}

	public function price()
	{
		return $this->hasMany('QuestPrice');
	}

}