<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('quest_id', 'date', 'amount');
	protected $visible = array('quest_id', 'date', 'amount');

	public function quest()
	{
		return $this->belongsTo('Quest');
	}

}