<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RequestStatus extends Model 
{

    protected $table = 'request_status';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('status_name', 'status_color');
    protected $visible = array('status_name', 'status_color');

    public function requests()
    {
        return $this->hasMany('Request', 'status_id');
    }

}