<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Request extends Model 
{

    protected $table = 'requests';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'status_id', 'request_content');
    protected $visible = array('status_id', 'request_content');
    protected $hidden = array('user_id');

    public function log()
    {
        return $this->hasMany('Reqestlog', 'request_id');
    }

}