<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Request extends Eloquent {

	protected $table = 'requests';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'status_id', 'request_content');
	protected $visible = array('status_id', 'request_content');
	protected $hidden = array('user_id');

	public function log()
	{
		return $this->hasMany('Reqestlog', 'request_id');
	}

}