<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MenuItem extends Eloquent {

	protected $table = 'menu_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function areas()
	{
		return $this->hasOne('App\Models\Area');
	}

	public function menu_item_category()
	{
		return $this->hasMany('App\Models\MenuItemCategory');
	}

	public function menu_item_ingredients()
	{
		return $this->hasMany('App\Models\MenuItemIngredients');
	}

}