<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function waiter()
	{
		return $this->hasOne('App\Models\Table');
	}

	public function order_item()
	{
		return $this->hasMany('App\Models\OrderItem');
	}

}