<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Admission extends Model 
{

    protected $table = 'admissions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('patient_id', 'clinician_id', 'ward_id', 'bed_id', 'status');
    protected $visible = array('patient_id', 'clinician_id', 'ward_id', 'bed_id', 'status');

    public function fluids()
    {
        return $this->hasMany('App\Fluid');
    }

}