<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Bed extends Model 
{

    protected $table = 'beds';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'ward_id', 'gender_type', 'status');
    protected $visible = array('name', 'ward_id', 'gender_type', 'status');

    public function ward()
    {
        return $this->belongsTo('App\Ward');
    }

}